//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.6

import wesual.Create   1.0
import wesual.Controls 1.0
import wesual.Ui       1.0

import wesual.data.Core 1.0

UiToolButton {
    id : shareButton

    // Share Actions Provided by Modules
    property list<Action>   shareActions
    // Documents to Share - is passed to the ShareAction
    property list <Document> documents
    // possible fileUrl to Share instead of Documents
    property url             fileUrl

    property size            targetSize

    property Action          action : shareActions[0] || null

    property bool shareOnClick : true

    function share() {
        if (shareActions.length === 1) {
            shareActions[0].trigger();
        } else {
            shareMenu.show();
        }
    }

    Component.onCompleted : {
        var count = ModuleManager.modules.length;
        var items = [];
        for (var i = 0; i < count; ++i) {
            var module = ModuleManager.modules[i];
            var component = module.createComponent(
                        "wesual.component.ShareAction",
                        shareButton);
            if (component) {
                var item = component.createObject(shareButton);
                item.documents = Qt.binding(function(){
                    return shareButton.documents;
                });
                item.fileUrl = Qt.binding(function(){
                    return shareButton.fileUrl;
                });
                item.targetSize = Qt.binding(function(){
                    return shareButton.targetSize;
                });
                items.push(item.action);
            }
        }
        shareActions = items;
    }

    text     : qsTrId("e0454161a17146aa")
    iconName : "fb-settings"
    down     : shareMenu.popupVisible
    enabled  : shareActions.length > 0

    onClicked : {
        if (shareOnClick) {
            share();
        }
    }

    ContextMenu {
        id : shareMenu

        contentWidth : shareButton.width
        anchors {
            top : shareButton.bottom
        }
        clickPosition : shareButton.mapToItem(shareButton, 0, 0)
        items : shareButton.shareActions
    }

}

